package ru.yandex.solomon.coremon.meta.service.handler;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.google.common.collect.Iterables;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardImpl;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;
import ru.yandex.solomon.coremon.meta.service.ShardKeyAndMetricKey;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;
import ru.yandex.solomon.metabase.api.protobuf.Metric;

import static ru.yandex.solomon.coremon.meta.service.handler.MetabaseShards.ensureReadyToWrite;

/**
 * @author Vladimir Gordiychuk
 */
public class CreateOneHandler {
    private final MetabaseShardResolver<MetabaseShardImpl> shardResolver;

    public CreateOneHandler(MetabaseShardResolver<MetabaseShardImpl> shardResolver) {
        this.shardResolver = shardResolver;
    }

    public CompletableFuture<CreateOneResponse> createOne(CreateOneRequest request) {
        Metric metric = request.getMetric();
        var key = ShardKeyAndMetricKey.of(LabelConverter.protoToLabels(metric.getLabelsList()));
        MetabaseShardImpl shard = shardResolver.resolveShard(key.getShardKey());
        ensureReadyToWrite(shard);

        Metric metricWithoutShardKey = metric.toBuilder()
                .clearLabels()
                .addAllLabels(LabelConverter.labelsToProtoList(key.getMetricKey()))
                .build();

        return shard.createMetrics(Labels.empty(), List.of(metricWithoutShardKey))
                .thenApply(metrics -> CreateOneResponse.newBuilder()
                        .setStatus(EMetabaseStatusCode.OK)
                        .setMetric(Proto.toProto(Iterables.getOnlyElement(metrics), key.getShardKey().toLabels()))
                        .build());
    }
}
