package ru.yandex.solomon.coremon.meta.service.handler;


import ru.yandex.solomon.labels.protobuf.LabelSelectorConverter;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.labels.query.ShardSelectors;
import ru.yandex.solomon.metabase.api.protobuf.FindRequest;
import ru.yandex.solomon.metabase.api.protobuf.TSliceOptions;

/**
 * @author Vladimir Gordiychuk
 */
public class ParsedFindRequest {
    private static final int METRICS_HARD_LIMIT = 20_000;

    public final int numId;
    public final boolean useNewFormat;
    public final String folderId;
    public final Selectors shardSelector;
    public final Selectors metricsSelector;
    public final int offset;
    public final int limit;
    public final long expiredAt;

    public ParsedFindRequest(FindRequest request) {
        numId = request.getShardId();
        useNewFormat = request.hasNewSelectors() || request.getFillMetricName();
        folderId = request.getFolderId();

        Selectors selector = useNewFormat
                ? LabelSelectorConverter.protoToSelectors(request.getNewSelectors())
                : LabelSelectorConverter.protoToSelectors(request.getSelectorsList());

        shardSelector = ShardSelectors.onlyShardKey(selector);
        metricsSelector = ShardSelectors.withoutShardKey(selector);

        TSliceOptions sliceOptions = request.getSliceOptions();
        // TODO: non zero offset leads to wrong behavior in case of cross shard search
        offset = sliceOptions.getOffset();
        limit = (request.hasSliceOptions() && sliceOptions.getLimit() >= 0)
                ? Math.min(sliceOptions.getLimit(), METRICS_HARD_LIMIT)
                : METRICS_HARD_LIMIT;
        expiredAt = request.getDeadlineMillis();
    }
}
