package ru.yandex.solomon.coremon.meta.service.handler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.NamedCoremonMetric;
import ru.yandex.solomon.coremon.meta.service.cloud.ResourceMap;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.metabase.api.protobuf.Metric;
import ru.yandex.solomon.model.protobuf.Label;
import ru.yandex.solomon.model.protobuf.MetricId;
import ru.yandex.solomon.model.protobuf.MetricTypeConverter;

/**
 * @author Vladimir Gordiychuk
 */
public class Proto {
    public static Metric toProto(NamedCoremonMetric metric, Labels shardLabels) {
        return Metric.newBuilder()
                .setMetricId(MetricId.newBuilder()
                        .setShardId(metric.getShardId())
                        .setLocalId(metric.getLocalId())
                        .build())
                .setName(metric.getName())
                .addAllLabels(LabelConverter.labelsToProtoList(shardLabels))
                .addAllLabels(LabelConverter.labelsToProtoList(metric.getLabels()))
                .setType(MetricTypeConverter.toProto(metric.getType()))
                .setCreatedAtMillis(TimeUnit.SECONDS.toMillis(metric.getCreatedAtSeconds()))
                .build();
    }

    public static Metric toProto(NamedCoremonMetric metric, List<Label> shardLabels, Map<String, ResourceMap> resources) {
        var result = Metric.newBuilder()
                .setMetricId(MetricId.newBuilder()
                        .setShardId(metric.getShardId())
                        .setLocalId(metric.getLocalId())
                        .build())
                .setName(metric.getName())
                .addAllLabels(shardLabels)
                .setType(MetricTypeConverter.toProto(metric.getType()))
                .setCreatedAtMillis(TimeUnit.SECONDS.toMillis(metric.getCreatedAtSeconds()));

        if (resources.isEmpty()) {
            result.addAllLabels(LabelConverter.labelsToProtoList(metric.getLabels()));
        } else {
            metric.getLabels().forEach(label -> {
                var resourceMap = resources.get(label.getKey());
                if (resourceMap == null) {
                    result.addLabels(LabelConverter.labelToProto(label));
                    return;
                }

                var resource = resourceMap.getResourceById(label.getValue());
                if (resource == null || !resource.hasName()) {
                    result.addLabels(LabelConverter.labelToProto(label));
                    return;
                }

                result.addLabels(Label.newBuilder()
                        .setKey(label.getKey())
                        .setValue(resource.getNameOrId())
                        .build());
            });
        }

        return result.build();
    }
}
