package ru.yandex.solomon.coremon.meta.service.handler;

import java.util.concurrent.CompletableFuture;

import ru.yandex.misc.thread.WhatThreadDoes;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardImpl;
import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;

import static ru.yandex.solomon.coremon.meta.service.handler.MetabaseShards.ensureReadyToWrite;

/**
 * @author Vladimir Gordiychuk
 */
public class ResolveLogsHandler {
    private final MetabaseShardResolver<MetabaseShardImpl> shardResolver;

    public ResolveLogsHandler(MetabaseShardResolver<MetabaseShardImpl> shardResolver) {
        this.shardResolver = shardResolver;
    }

    public CompletableFuture<TResolveLogsResponse> resolveLogs(TResolveLogsRequest request) {
        int numId = request.getNumId();
        WhatThreadDoes.Handle h = WhatThreadDoes.push("Metabase#resolveLogs " + Integer.toUnsignedLong(numId));
        try {
            var shard = shardResolver.resolveShard(request.getNumId());
            ensureReadyToWrite(shard);
            return shard.resolveLogs(request);
        } finally {
            h.popSafely();
        }
    }
}
