package ru.yandex.solomon.coremon.meta.ttl;

import java.util.Arrays;
import java.util.stream.Stream;

import javax.annotation.Nullable;

import ru.yandex.solomon.coremon.meta.FileCoremonMetric;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileMetricId;


/**
 * @author Sergey Polovko
 */
public class Batch {

    private static final int INITIAL_CAPACITY = 10;

    private FileCoremonMetric[] metrics;
    private int size;

    public Batch() {
        this.metrics = new FileCoremonMetric[INITIAL_CAPACITY];
        this.size = 0;
    }

    public void add(FileCoremonMetric metric) {
        if (!StockpileLocalId.isValid(metric.getLocalId())) {
            String metricId = StockpileMetricId.toString(metric.getShardId(), metric.getLocalId());
            throw new IllegalArgumentException("metric " + metricId + " is invalid");
        }
        if (size == metrics.length) {
            metrics = Arrays.copyOf(metrics, size + size / 2);
        }
        metrics[size++] = metric;
    }

    @Nullable
    public FileCoremonMetric pop() {
        if (size == 0) {
            return null;
        }
        size--;
        FileCoremonMetric metric = metrics[size];
        metrics[size] = null;
        return metric;
    }

    public boolean isEmpty() {
        return size == 0;
    }

    public int size() {
        return size;
    }

    public Stream<FileCoremonMetric> stream() {
        return Arrays.stream(metrics, 0, size);
    }

    public FileCoremonMetric getMetric(int index) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index(" + index + ") is out of bound [0.." + size + ')');
        }
        return metrics[index];
    }
}
