package ru.yandex.solomon.coremon.meta.ttl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2LongMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;


/**
 * @author Sergey Polovko
 */
class DeletionManagerMetrics {

    final AsyncMetrics tasks;
    final AsyncMetrics metaLoads;
    final AsyncMetrics resourceLoads;
    final AsyncMetrics deletionsStockpile;
    final AsyncMetrics deletionsKikimr;
    final Rate metricsDeleted;

    private final MetricRegistry registry;
    final ConcurrentMap<String, GaugeInt64> unknownRefByServiceProvider = new ConcurrentHashMap<>();

    public DeletionManagerMetrics(MetricRegistry registry) {
        this.registry = registry;
        final String prefix = "metabase.ttl.";

        this.tasks = new AsyncMetrics(registry, prefix + "tasks");
        this.metricsDeleted = registry.rate(prefix + "metricsDeleted");
        this.metaLoads = new AsyncMetrics(registry, prefix + "metaLoads");
        this.resourceLoads = new AsyncMetrics(registry, prefix + "resourceLoads");
        this.deletionsStockpile = new AsyncMetrics(registry, prefix + "deletionsStockpile");
        this.deletionsKikimr = new AsyncMetrics(registry, prefix + "deletionsKikimr");
    }

    void updateUnknownRef(Object2LongMap<String> unknownByServiceProvider) {
        var serviceProviders = Sets.union(unknownByServiceProvider.keySet(), this.unknownRefByServiceProvider.keySet());
        for (var serviceProvider : serviceProviders) {
            GaugeInt64 metric = unknownRefByServiceProvider.get(serviceProvider);
            if (metric == null) {
                metric = registry.gaugeInt64("metabase.metrics_with_unknown_reference", Labels.of("service_provider", serviceProvider));
                unknownRefByServiceProvider.put(serviceProvider, metric);
            }

            metric.set(unknownByServiceProvider.getLong(serviceProvider));
        }
    }
}
