package ru.yandex.solomon.coremon.meta.ttl;

import ru.yandex.solomon.coremon.meta.FileCoremonMetric;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileBatch extends Batch {
    private final int stockpileShardId;

    public StockpileBatch(int stockpileShardId) {
        this.stockpileShardId = stockpileShardId;
    }

    @Override
    public void add(FileCoremonMetric metric) {
        if (stockpileShardId != metric.getShardId()) {
            throw new IllegalArgumentException(
                    "metric belongs to a different stockpile shard: " +
                            "batch(" + stockpileShardId + ") != metric(" + metric.getShardId() + ')');
        }
        super.add(metric);
    }

    public int getStockpileShardId() {
        return stockpileShardId;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{" +
                "shardId=" + stockpileShardId +
                ", size=" + size() +
                ", ... " +
                '}';
    }
}
