package ru.yandex.solomon.coremon.meta.ttl;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.logbroker.agent.client.Client;
import ru.yandex.logbroker.agent.client.SessionMetrics;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.coremon.TUnknownReferenceTrackerConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.spring.ConditionalOnBean;
import ru.yandex.solomon.spring.ConditionalOnMissingBean;
import ru.yandex.solomon.unified.agent.UnifiedAgentClients;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class UnknownReferenceTrackerContext {

    private final ThreadPoolProvider threads;
    private final MetricRegistry registry;

    public UnknownReferenceTrackerContext(ThreadPoolProvider threads, MetricRegistry registry) {
        this.threads = threads;
        this.registry = registry;
    }

    @Bean
    @ConditionalOnBean(TUnknownReferenceTrackerConfig.class)
    protected Client client(TUnknownReferenceTrackerConfig config) {
        return UnifiedAgentClients.makeClient(config.getUnifiedAgentClient(), threads, registry);
    }

    @Bean
    @ConditionalOnBean(TUnknownReferenceTrackerConfig.class)
    public UnknownReferenceTracker tracker(Client client) {
        var session = client.newSession()
                .setMetrics(new SessionMetrics(registry.subRegistry("session", "unknown-reference-tracker")))
                .build();

        return new UnknownReferenceTrackerImpl(session);
    }

    @Bean
    @ConditionalOnMissingBean(TUnknownReferenceTrackerConfig.class)
    public UnknownReferenceTracker noopIssueTracker() {
        return new UnknownReferenceTrackerNoop();
    }
}
