package ru.yandex.solomon.coremon.meta.ttl;

import javax.annotation.WillCloseWhenClosed;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.logbroker.agent.client.Session;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.core.conf.ShardKeyAndId;
import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.util.time.InstantUtils;

/**
 * @author Vladimir Gordiychuk
 */
public class UnknownReferenceTrackerImpl implements UnknownReferenceTracker {
    private static final Logger logger = LoggerFactory.getLogger(UnknownReferenceTrackerImpl.class);

    @WillCloseWhenClosed
    private final Session session;
    private final ObjectMapper mapper;

    public UnknownReferenceTrackerImpl(@WillCloseWhenClosed Session session) {
        this.session = session;
        this.mapper = new ObjectMapper();
    }

    @Override
    public void unknownReference(ShardKeyAndId key, String resourceId, String label, CoremonMetric metric) {
        try {
            var root = mapper.createObjectNode()
                    .put("ts", String.valueOf(InstantUtils.currentTimeSeconds()))
                    .put("service", key.getShardKey().getService())
                    .put("label", label)
                    .put("cloudId", key.getShardKey().getProject())
                    .put("folderId", key.getShardKey().getCluster())
                    .put("numId", Long.toUnsignedString(key.getNumId()))
                    .put("shardId", key.getShardId())
                    .put("resourceId", resourceId)
                    .put("createdAt", String.valueOf(metric.getCreatedAtSeconds()))
                    .put("latestPointAt", String.valueOf(metric.getLastPointSeconds()))
                    .set("metric", labelsToJson(metric.getLabels()));

            session.send(mapper.writeValueAsString(root));
        } catch (Throwable e) {
            logger.warn("fail to send unknown reference {}, {}", key, resourceId, e);
        }
    }

    private ObjectNode labelsToJson(Labels labels) {
        var root = mapper.createObjectNode();
        labels.forEach(label -> {
            root.put(label.getKey(), label.getValue());
        });
        return root;
    }

    @Override
    public void close() throws Exception {
        session.close();
    }
}
