package ru.yandex.solomon.coremon.meta.ttl.tasks;

/**
 * @author Sergey Polovko
 */
public final class FailedTask implements Task {

    private final long createdAtMillis;
    private final TaskStats stats;
    private final Throwable exception;
    private final long exceptionAtMillis;

    public FailedTask(long createdAtMillis, TaskStats stats, Throwable exception) {
        this.createdAtMillis = createdAtMillis;
        this.stats = stats;
        this.exception = exception;
        this.exceptionAtMillis = System.currentTimeMillis();
    }

    @Override
    public TaskStats getStats() {
        return stats;
    }

    @Override
    public long getCreatedAtMillis() {
        return createdAtMillis;
    }

    public Throwable getException() {
        return exception;
    }

    public long getExceptionAtMillis() {
        return exceptionAtMillis;
    }
}
