package ru.yandex.solomon.coremon.meta.ttl.tasks;

import javax.annotation.concurrent.Immutable;


/**
 * @author Sergey Polovko
 */
@Immutable
public final class TaskStats {

    private final int totalMetrics;
    private final int deletedMetrics;
    private final int unknownReference;
    private final long durationMillis;
    private final double progress;

    public TaskStats(int totalMetrics, int deletedMetrics, int unknownReference, long durationMillis, double progress) {
        this.totalMetrics = totalMetrics;
        this.deletedMetrics = deletedMetrics;
        this.unknownReference = unknownReference;
        this.durationMillis = durationMillis;
        this.progress = progress;
    }

    public int getTotalMetrics() {
        return totalMetrics;
    }

    public int getDeletedMetrics() {
        return deletedMetrics;
    }

    public int getUnknownReference() {
        return unknownReference;
    }

    public long getDurationMillis() {
        return durationMillis;
    }

    public double getProgress() {
        return progress;
    }

    @Override
    public String toString() {
        return String.format("deleted [%d/%d/%d] in %dms", unknownReference, deletedMetrics, totalMetrics, durationMillis);
    }
}
