package ru.yandex.solomon.coremon.meta;

import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.coremon.meta.file.FileMetricsCollection;
import ru.yandex.solomon.util.concurrent.AutoresetEvent;


/**
 * The same collection as {@link FileMetricsCollection} but with capability to wait
 * maintenance tasks running in the background.
 *
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class AwaitableFileMetricsCollection extends FileMetricsCollection {
    private final AutoresetEvent actEvent = new AutoresetEvent();

    public AwaitableFileMetricsCollection(Executor executor, int[] levelsSizes, CoremonMetricArray metrics) {
        super("Awaitable", executor, levelsSizes, metrics);
    }

    @Override
    protected void act() {
        super.act();
        actEvent.signal();
    }

    public void awaitActDone() {
        actEvent.await();
    }
}
