package ru.yandex.solomon.coremon.meta.db.memory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.CoremonMetric;
import ru.yandex.solomon.coremon.meta.FileCoremonMetric;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class InMemoryMetricsDaoTest {

    private InMemoryMetricsDao dao;

    @Before
    public void setUp() throws Exception {
        dao = new InMemoryMetricsDao();
    }

    @Test
    public void readEmpty() {
        long count = dao.findMetrics(array -> {}, OptionalLong.empty()).join();
        assertEquals(0, count);
    }

    @Test
    public void readAll() {
        var expected = IntStream.range(100, 5_000)
                .mapToObj(ignore -> randomMetric())
                .collect(Collectors.toList());
        dao.add(expected);

        List<CoremonMetric> actual = new ArrayList<>();
        long count = dao.findMetrics(array -> {
            for (int index = 0; index < array.size(); index++) {
                actual.add(new FileCoremonMetric(array.get(index)));
            }
        }, OptionalLong.empty()).join();

        assertEquals(expected.size(), count);

        expected.sort(Comparator.comparingLong(CoremonMetric::getLocalId));
        actual.sort(Comparator.comparingLong(CoremonMetric::getLocalId));
        assertArrayEquals(expected.toArray(), actual.toArray());
    }

    private CoremonMetric randomMetric() {
        var random = ThreadLocalRandom.current();
        int shardId = StockpileShardId.random(1000, random);
        long localId = StockpileLocalId.random(random);
        var labels = Labels.of("key", "value-"+random.nextLong());
        return new FileCoremonMetric(shardId, localId, labels, MetricType.DGAUGE);
    }
}
