package ru.yandex.solomon.coremon.meta.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.random.Random2;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;


/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class LabelListSortedSerializeTest {

    @Test
    public void testSerialize() {
        Assert.assertEquals("&", LabelListSortedSerialize.format(build()));
        Assert.assertEquals("&x=y&", LabelListSortedSerialize.format(build("x", "y")));
        Assert.assertEquals("&a=b&x=y&", LabelListSortedSerialize.format(build("a", "b", "x", "y")));
    }

    @Test
    public void testSerializeSpecial() {
        Assert.assertEquals("&x=y\\&&", LabelListSortedSerialize.format(build("x", "y&")));
        Assert.assertEquals("&x\\&=y&", LabelListSortedSerialize.format(build("x&", "y")));
        Assert.assertEquals("&x\\=z=y&", LabelListSortedSerialize.format(build("x=z", "y")));
        Assert.assertEquals("&x\nz=y&", LabelListSortedSerialize.format(build("x\nz", "y")));
    }

    @Test
    public void testDeserialize() {
        Assert.assertEquals(build(), LabelListSortedSerialize.parse("&"));
        Assert.assertEquals(build("x", "y"), LabelListSortedSerialize.parse("&x=y&"));
        Assert.assertEquals(build("a", "b", "x", "y"), LabelListSortedSerialize.parse("&a=b&x=y&"));
    }

    @Test
    public void testDeserializeSpecial() {
        Assert.assertEquals(build("x", "y&"), LabelListSortedSerialize.parse("&x=y\\&&"));
        Assert.assertEquals(build("x&", "y"), LabelListSortedSerialize.parse("&x\\&=y&"));
        Assert.assertEquals(build("x=z", "y"), LabelListSortedSerialize.parse("&x\\=z=y&"));
        Assert.assertEquals(build("x\nz", "y"), LabelListSortedSerialize.parse("&x\nz=y&"));
    }

    private static Labels build(String... keyvals) {
        Assert.assertEquals(0, keyvals.length % 2);
        LabelsBuilder builder = Labels.builder();
        for (int i = 0; i < keyvals.length; i += 2) {
            String key = keyvals[i];
            String value = keyvals[i + 1];
            builder.add(key, value);
        }
        return builder.build();
    }

    @Test
    public void testSerializeDeserializeRandom() {
        Random2 r = new Random2(55);
        for (int i = 0; i < 500; i++) {
            int count = r.nextInt(12);
            LabelsBuilder builder = Labels.builder(count);
            for (int l = 0; l < count; l++) {
                builder.add(randomString(r), randomString(r));
            }
            Labels labels = builder.build();
            Assert.assertEquals(labels, LabelListSortedSerialize.parse(LabelListSortedSerialize.format(labels)));
        }
    }

    private static String randomString(Random2 r) {
        char[] cs = new char[r.nextInt(15) + 1]; // empty names/vals are not allowed
        for (int i = 0; i < cs.length; i++) {
            cs[i] = randomChar(r);
        }
        return new String(cs);
    }

    private static char randomChar(Random2 r) {
        char[] special = new char[]{'=', '&', '\\'};
        switch (r.nextInt(10)) {
            case 0:
                return special[r.nextInt(special.length)];
            default:
                return r.nextChar();
        }
    }
}
