package ru.yandex.solomon.coremon.meta.db.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.coremon.meta.db.DeletedMetricsDao;
import ru.yandex.solomon.coremon.meta.db.DeletedMetricsDaoTest;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

/**
 * @author Stanislav Kashirin
 */
public class YdbDeletedMetricsDaoTest extends DeletedMetricsDaoTest {

    @ClassRule
    public static final LocalKikimr localKikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();

    private YdbHelper ydb;
    private YdbDeletedMetricsDao dao;

    @Before
    public void setUp() throws Exception {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + testName.getMethodName());

        dao = new YdbDeletedMetricsDao(ydb.getTableClient(), ydb.getRootPath());
        dao.createSchema().join();
    }

    @After
    public void tearDown() {
        ydb.close();
    }

    @Override
    protected DeletedMetricsDao getDao() {
        return dao;
    }

}
