package ru.yandex.solomon.coremon.meta.mem;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.LabelsFormat;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;

/**
 * @author Vladimir Gordiychuk
 */
public class MemOnlyMetricsCollectionImplTest {

    private MemOnlyMetricsCollectionImpl collection;

    @Before
    public void setUp() throws Exception {
        collection = new MemOnlyMetricsCollectionImpl();
    }

    @Test
    public void size() {
        assertEquals(0, collection.size());
        collection.put(Labels.of(), labels("name=alice"), new int[10]);
        assertEquals(1, collection.size());
        collection.put(Labels.of(), labels("name=bob"), new int[5]);
        assertEquals(2, collection.size());

        collection.clear();
        assertEquals(0L, collection.size());
    }

    @Test
    public void differentByOptLabels() {
        Object sas = new Object();
        collection.put(labels("DC=Sas"), labels("name=alice"), sas);

        Object vla = new Object();
        collection.put(labels("DC=Vla"), labels("name=alice"), vla);

        assertSame(sas, collection.getOrNull(labels("DC=Sas"), labels("name=alice")));
        assertSame(vla, collection.getOrNull(labels("DC=Vla"), labels("name=alice")));
    }

    private Labels labels(String labels) {
        return LabelsFormat.parse(labels);
    }
}
