package ru.yandex.solomon.coremon.meta.service;

import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.metabase.api.protobuf.Metric;
import ru.yandex.solomon.model.protobuf.MetricId;

import static org.hamcrest.CoreMatchers.equalTo;

/**
 * @author Vladimir Gordiychuk
 */
class MetricMatchers {

    static Matcher<Metric> hasMetricId(MetricId metricId) {
        return new FeatureMatcher<>(equalTo(metricId), "metricId", "metricId") {
            @Override
            protected MetricId featureValueOf(final Metric target) {
                return target.getMetricId();
            }
        };
    }

    static Matcher<Metric> hasLabels(Labels labels) {
        return new FeatureMatcher<>(equalTo(labels), "labelList", "labelList") {
            @Override
            protected Labels featureValueOf(final Metric target) {
                return LabelConverter.protoToLabels(target.getLabelsList());
            }
        };
    }

    static Matcher<Metric> hasMetric(String name, Labels labels) {
        return new TypeSafeMatcher<>() {
            @Override
            protected boolean matchesSafely(Metric item) {
                return name.equals(item.getName()) && labels.equals(LabelConverter.protoToLabels(item.getLabelsList()));
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("{name=" + name + ", labels=" + labels + "}");
            }
        };
    }
}
