package ru.yandex.solomon.coremon.meta.service.cloud;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class ReferenceLabelTest {

    @Test
    public void combineSame() {
        var left = new ReferenceLabel("resource_id", Set.of("disk"), Set.of("compute"), Set.of("folder"));
        var right = new ReferenceLabel("resource_id", Set.of("disk"), Set.of("compute"), Set.of("folder"));
        var expected = new ReferenceLabel("resource_id", Set.of("disk"), Set.of("compute"), Set.of("folder"));
        assertEquals(expected, ReferenceLabel.combine(left, right));
        assertEquals(expected, ReferenceLabel.combine(right, left));
    }

    @Test
    public void combineCrossFolder() {
        var left = new ReferenceLabel("resource_id", Set.of(), Set.of("compute"), Set.of());
        var right = new ReferenceLabel("resource_id", Set.of(), Set.of("compute"), Set.of("folder"));
        var expected = new ReferenceLabel("resource_id", Set.of(), Set.of("compute"), Set.of());
        assertEquals(expected, ReferenceLabel.combine(left, right));
        assertEquals(expected, ReferenceLabel.combine(right, left));
    }

    @Test
    public void combineExtendTypesToHigh() {
        var left = new ReferenceLabel("resource_id", Set.of("disk"), Set.of("compute"), Set.of("folder"));
        var right = new ReferenceLabel("resource_id", Set.of(), Set.of("compute"), Set.of("folder"));
        var expected = new ReferenceLabel("resource_id", Set.of(), Set.of("compute"), Set.of("folder"));
        assertEquals(expected, ReferenceLabel.combine(left, right));
        assertEquals(expected, ReferenceLabel.combine(right, left));
    }

    @Test
    public void combineDifferentTypes() {
        var left = new ReferenceLabel("resource_id", Set.of("disk"), Set.of("compute"), Set.of("folder"));
        var right = new ReferenceLabel("resource_id", Set.of("vm"), Set.of("compute"), Set.of("folder"));
        var expected = new ReferenceLabel("resource_id", Set.of("disk", "vm"), Set.of("compute"), Set.of("folder"));
        assertEquals(expected, ReferenceLabel.combine(left, right));
        assertEquals(expected, ReferenceLabel.combine(right, left));
    }

    @Test
    public void toMap() {
        var certificate = new ReferenceLabel("certificate", Set.of("certificate"), Set.of("certificate-manager"), Set.of("folder"));
        var vm = new ReferenceLabel("vm", Set.of("vm"), Set.of("certificate-manager"), Set.of("folder"));
        var resourceId = new ReferenceLabel("resource_id", Set.of(), Set.of("certificate-manager"), Set.of("folder"));
        var expected = Map.of("certificate", certificate, "vm", vm, "resource_id", resourceId);
        assertEquals(expected, ReferenceLabel.toMap(List.of(certificate, vm, resourceId)));
        assertEquals(expected, ReferenceLabel.toMap(List.of(certificate, vm, resourceId, resourceId)));
        assertEquals(expected, ReferenceLabel.toMap(Set.of(certificate, vm, resourceId)));
    }

    @Test
    public void toMapCombine() {
        var certificate = new ReferenceLabel("resource_id", Set.of("certificate"), Set.of("certificate-manager"), Set.of("folder"));
        var vm = new ReferenceLabel("resource_id", Set.of("vm"), Set.of("compute"), Set.of("folder"));
        var disk = new ReferenceLabel("resource_id", Set.of("disk"), Set.of("compute"), Set.of("folder"));

        var combined = new ReferenceLabel("resource_id", Set.of("certificate", "vm", "disk"), Set.of("compute", "certificate-manager"), Set.of("folder"));
        var expected = Map.of("resource_id", combined);
        assertEquals(expected, ReferenceLabel.toMap(List.of(certificate, vm, disk)));
        assertEquals(expected, ReferenceLabel.toMap(List.of(certificate, vm, disk, vm)));
    }
}
