package ru.yandex.solomon.coremon.meta.service.cloud;


import java.util.List;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import ru.yandex.solomon.coremon.meta.service.MetabaseShardResolver;

/**
 * @author Vladimir Gordiychuk
 */
public class ReferenceResolverStub implements ReferenceResolver {
    private final MetabaseShardResolver shardResolver;
    private final Multimap<String, ReferenceLabel> referencesByService = HashMultimap.create();

    public ReferenceResolverStub(MetabaseShardResolver shardResolver) {
        this.shardResolver = shardResolver;
    }

    @Override
    public List<ReferenceLabel> resolve(int numId) {
        var shard = shardResolver.resolveShard(numId);
        return List.copyOf(referencesByService.get(shard.getShardKey().getService()));
    }

    public void addReference(String service, ReferenceLabel reference) {
        referencesByService.put(service, reference);
    }
}
