package ru.yandex.solomon.coremon.meta.ttl;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.FileCoremonMetric;


/**
 * @author Sergey Polovko
 */
public class BatchTest {

    @Test
    public void add() {
        StockpileBatch b = new StockpileBatch(42);

        Assert.assertEquals(0, b.size());
        Assert.assertTrue(b.isEmpty());

        b.add(newMetric(42, 1));

        Assert.assertEquals(1, b.size());
        Assert.assertFalse(b.isEmpty());

        for (int i = 0; i < 100; i++) {
            b.add(newMetric(42, i + 2));
        }

        Assert.assertEquals(101, b.size());
        Assert.assertFalse(b.isEmpty());

        try {
            b.add(newMetric(57, 333));
            Assert.fail("exception is not thrown");
        } catch (IllegalArgumentException e) {
            Assert.assertTrue(e.getMessage().startsWith("metric belongs to a different stockpile shard"));
        }

        for (int i = 0; i < b.size(); i++) {
            long expectedLocalId = i + 1;
            long actualLocalId = b.getMetric(i).getLocalId();
            Assert.assertEquals(expectedLocalId, actualLocalId);
        }
    }

    @Test
    public void pop() {
        var b = new StockpileBatch(57);
        for (int i = 0; i < 5; i++) {
            b.add(newMetric(b.getStockpileShardId(), i + 1));
        }

        long expectedLongId = 5;
        while (!b.isEmpty()) {
            FileCoremonMetric metric = b.pop();
            Assert.assertNotNull(metric);

            Assert.assertEquals(expectedLongId, metric.getLocalId());
            expectedLongId--;
        }

        Assert.assertNull(b.pop());
        Assert.assertNull(b.pop());
    }

    private static FileCoremonMetric newMetric(int shardId, long localId) {
        return new FileCoremonMetric(shardId, localId, Labels.of("a", "b"), MetricType.DGAUGE);
    }
}
