package ru.yandex.solomon.coremon.meta.ttl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

import ru.yandex.solomon.coremon.meta.service.cloud.ResourceMap;
import ru.yandex.solomon.coremon.meta.ttl.Batcher.LoadResourceBatch;
import ru.yandex.solomon.name.resolver.client.Resource;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceLoaderStub implements ResourceLoader {
    private final ConcurrentMap<String, Resource> resourceById = new ConcurrentHashMap<>();

    public void addResource(Resource... resources) {
        for (var resource : resources) {
            resourceById.put(resource.resourceId, resource);
        }
    }

    @Override
    public CompletableFuture<ResourceMap> loadResources(String projectId, LoadResourceBatch batch) {
        return CompletableFuture.supplyAsync(() -> {
            var resources = batch.resourceIds()
                    .stream()
                    .map(resourceById::get)
                    .filter(Objects::nonNull)
                    .map(Resource::new)
                    .collect(Collectors.toList());
            return new ResourceMap(resources);
        });
    }
}
