package ru.yandex.solomon.coremon.meta.ttl.tasks;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.FileCoremonMetric;
import ru.yandex.solomon.coremon.meta.ttl.Batcher.DeleteBatch;
import ru.yandex.solomon.coremon.meta.ttl.Deleter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

/**
 * @author Vladimir Gordiychuk
 */
public class DeleterStub implements Deleter {
    private final Map<Labels, FileCoremonMetric> expectDelete = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<Void> delete(int numId, DeleteBatch batch) {
        return CompletableFuture.runAsync(() -> {
            for (int index = 0; index < batch.size(); index++) {
                var metric = batch.getMetric(index);
                var expect = expectDelete.remove(metric.getLabels());
                assertEquals(expect, metric);
            }
        });
    }

    public void expectDelete(FileCoremonMetric... metrics) {
        for (var metric : metrics) {
            assertNull(expectDelete.put(metric.getLabels(), metric));
        }
    }

    public void ensureAllExpectedDeleted() {
        assertEquals("not all expected metrics was deleted", Map.of(), expectDelete);
    }
}
