package ru.yandex.solomon.coremon.meta.ttl.tasks;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.coremon.meta.FileCoremonMetric;
import ru.yandex.solomon.coremon.meta.ttl.Batcher.LoadMetaBatch;
import ru.yandex.solomon.coremon.meta.ttl.MetaLoader;
import ru.yandex.stockpile.api.MetricMeta;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

/**
 * @author Vladimir Gordiychuk
 */
public class MetaLoaderStub implements MetaLoader {
    private final Map<Labels, FileCoremonMetric> expectLoad = new ConcurrentHashMap<>();
    private final Map<Labels, Instant> latestTsByLabels = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<List<MetricMeta>> loadMeta(LoadMetaBatch batch) {
        return CompletableFuture.supplyAsync(() -> {
            List<MetricMeta> result = new ArrayList<>();
            for (int index = 0; index < batch.size(); index++) {
                var metric = batch.getMetric(index);
                var expect = expectLoad.remove(metric.getLabels());
                assertEquals(expect, metric);

                var latestTs = latestTsByLabels.get(metric.getLabels());
                if (latestTs == null) {
                    continue;
                }

                result.add(MetricMeta.newBuilder()
                        .setLocalId(metric.getLocalId())
                        .setLastTsMillis(latestTs.toEpochMilli())
                        .build());
            }

            return result;
        });
    }

    public void expectLoad(FileCoremonMetric... metrics) {
        for (var metric : metrics) {
            assertNull(expectLoad.put(metric.getLabels(), metric));
        }
    }

    public void setLatestTs(Labels labels, Instant latestTs) {
        latestTsByLabels.put(labels, latestTs);
    }


    public void ensureAllExpectedLoaded() {
        assertEquals("not all expected metrics was loaded", Map.of(), expectLoad);
    }
}
