#!/bin/sh -e

if [ $# -lt 2 ]; then
    echo "Usage: $0 <service> <dc>"
    echo
    echo "where:"
    echo "  - service one of {metabase,stockpile}"
    echo "  - dc      one of {sas,vla}"
    exit 1
fi

service="${1}"
dc="${2}"

case ${dc} in
    sas|vla) ;;
    *)
        echo "unknown DC: ${dc}"
        exit 1
        ;;
esac

# resolve_group <group>
resolve_group() {
    curl -s https://c.yandex-team.ru/api/groups2hosts/${1} | sort
}

case "${service}" in
    metabase)
        port=5710
        hosts=$(resolve_group solomon_prod_fetcher_${dc})
        ;;
    stockpile)
        port=5700
        hosts=$(resolve_group solomon_prod_stockpile_${dc})
        ;;
    *)
        echo "unknown service: ${service}"
        exit 1
        ;;
esac

for host in ${hosts}; do
    echo "block drop out proto tcp from any to ${host} port ${port}"
done | sudo pfctl -f -

sudo pfctl -e
