from solomon.services.dataproxy.ctl.lib.point cimport (TVariantPoint, TValue, GetVariant,
                                                       TDouble, TLong, TSummaryInt, TSummaryDouble,
                                                       THistogram, TLogHistogram)
from solomon.services.dataproxy.ctl.lib.timeseries cimport FromPyProto
from solomon.services.dataproxy.ctl.lib.pool cimport PoolFromPyProto


cdef SerializeValue(TValue value):
    cdef const TDouble* d = GetVariant[TDouble](value)
    cdef const TLong* l = GetVariant[TLong](value)
    cdef const TSummaryInt* si = GetVariant[TSummaryInt](value)
    cdef const TSummaryDouble* sd = GetVariant[TSummaryDouble](value)
    cdef const THistogram* h = GetVariant[THistogram](value)
    cdef const TLogHistogram* lh = GetVariant[TLogHistogram](value)
    if d != NULL: return d.Num if (d.Denom == 0 or d.Denom == 1000) else 1e3 * d.Num / d.Denom
    if l != NULL: return l.Value
    if si != NULL: return {"count": si.CountValue, "sum": si.Sum, "min": si.Min, "max": si.Max, "last": si.Last}
    if sd != NULL: return {"count": sd.CountValue, "sum": sd.Sum, "min": sd.Min, "max": sd.Max, "last": sd.Last}
    if h != NULL:
        return {
            "buckets": [{"bin": h.Buckets[i].UpperBound, "value": h.Buckets[i].Value} for i in range(h.Buckets.size())],
            "denom": h.Denom,
        }
    if lh != NULL:
        return {
            "zeros": lh.ZeroCount,
            "start_pow": lh.StartPower,
            "base": lh.Base,
            "values": [lh.Values[i] for i in range(lh.Values.size())],
        }
    return None


def ParseDataReadManyResponse(resp):
    pool_bytes = PoolFromPyProto(resp.string_pool.SerializeToString())
    pool = [x.decode() for x in pool_bytes]
    print(pool)
    ret = []
    for metric in resp.metrics[:]:
        print(metric)
        ret_metric = {}
        meta = metric.metric
        ret_metric['type'] = meta.type
        ret_metric['labels'] = {pool[k]: pool[v] for k, v in zip(meta.labels_idx[0::2], meta.labels_idx[1::2])}

        data = metric.time_series
        points = []
        buf = data.SerializeToString()
        ts = FromPyProto(meta.type, buf)
        iter = ts.get().Iterator()
        point = new TVariantPoint()
        while iter.get().Next(point):
            pyPoint = {
                'ts': point.Time.GetValue() / 1e6,
                'step': point.Step.GetValue() / 1e6,
                'value': SerializeValue(point.Value)
            }
            if point.Count:
                pyPoint['count'] = point.Count
            if point.Merge:
                pyPoint['merge'] = point.Merge
            points.append(pyPoint)
        del point
        ts.release()
        
        ret_metric['time_series'] = points
        ret.append(ret_metric)
        
    return ret
