from libcpp cimport bool
from libcpp.vector cimport vector

from util.datetime.base cimport TInstant, TDuration
from util.system.types cimport i16, i64, ui64


cdef extern from "<variant>" namespace "std" nogil:
    
    cdef cppclass variant[T1,T2,T3,T4,T5,T6]:
        pass

cdef extern from "<solomon/libs/cpp/ts_codec/points.h>" namespace "NSolomon::NTs::NValue" nogil:

    cdef cppclass TDouble:
        double Num
        ui64 Denom

    cdef cppclass TLong:
        i64 Value

    cdef cppclass TSummary[T]:
        i64 CountValue
        T Sum
        T Min
        T Max
        T Last

    cdef cppclass TBucket "NSolomon::NTs::NValue::THistogram::TBucket":
        double UpperBound
        ui64 Value

    cdef cppclass THistogram:
        ui64 Denom
        vector[TBucket] Buckets

    cdef cppclass TLogHistogram:
        vector[double] Values
        ui64 ZeroCount
        i16 StartPower
        i16 MaxBucketCount
        double Base

ctypedef TSummary[i64] TSummaryInt;
ctypedef TSummary[double] TSummaryDouble;
ctypedef variant[TDouble, TLong, TSummaryInt, TSummaryDouble, THistogram, TLogHistogram] TValue

cdef extern from "<solomon/libs/cpp/ts_codec/points.h>" namespace "NSolomon::NTs" nogil:

    cdef cppclass TVariantPoint:
        TInstant Time
        TDuration Step
        ui64 Count
        bool Merge
        TValue Value

cdef extern from "<solomon/services/dataproxy/ctl/lib/point.h>" namespace "NSolomon::NDataproxy::NCtl" nogil:
    
    cdef T* GetVariant[T](const TValue& value)

