#include "timeseries.h"

#include <solomon/protos/model/timeseries.pb.h>
#include <solomon/services/dataproxy/lib/timeseries/protobuf.h>

using namespace yandex::solomon::model;

namespace NSolomon::NDataProxy::NCtl {

std::unique_ptr<ITimeSeries> FromPyProto(yandex::solomon::model::MetricType typeFallback, const TString& pyPbTimeSeries) {
    TimeSeries timeSeries;
    Y_VERIFY(timeSeries.ParseFromString(pyPbTimeSeries));
    return FromProto(typeFallback, timeSeries);
}

}
