from solomon.services.dataproxy.ctl.lib.point cimport TVariantPoint

from libcpp cimport bool
from libcpp.memory cimport unique_ptr

from util.generic.string cimport TString
from util.system.types cimport ui32


cdef extern from "<solomon/protos/model/metric.pb.h>" namespace "yandex::solomon::model" nogil:
    cdef enum MetricType:
        pass


cdef extern from "<solomon/services/dataproxy/lib/timeseries/timeseries.h>" namespace "NSolomon::NDataProxy" nogil:

    cdef cppclass ITimeSeriesIter:
        bool Next(TVariantPoint* point)

    cdef cppclass ITimeSeries:
        ui32 PointCount()
        unique_ptr[ITimeSeriesIter] Iterator()

cdef extern from "<solomon/services/dataproxy/ctl/lib/timeseries.h>" namespace "NSolomon::NDataProxy::NCtl" nogil:
    
    cdef unique_ptr[ITimeSeries] FromPyProto(MetricType typeFallback, const TString& timeseries)
