package main

import (
	dataproxy "a.yandex-team.ru/solomon/services/dataproxy/api"
	"github.com/golang/protobuf/proto"
	"github.com/yandex/pandora/core"
	"time"
)

type ProtoAmmo struct {
	Message proto.Message
}

func (a ProtoAmmo) Tag() string {
	return "tag"
}

func NewAmmo() core.Ammo {
	ts := uint64(time.Now().UnixNano() / 1e6)
	return &ProtoAmmo{
		Message: &dataproxy.ReadManyRequest{
			ProjectId:           "kwyt",
			FromMillis:          ts - 300_000,
			ToMillis:            ts,
			MaxTimeSeriesFormat: 38,
			Query: &dataproxy.ReadManyRequest_Lookup_{
				Lookup: &dataproxy.ReadManyRequest_Lookup{
					Selectors: "{cluster='rthub-appdocs', service='cloud', instance='cluster', type='isolation', sensor='ProcessesKilledByTimeoutCount'}",
					Limit:     100,
				},
			},
		},
	}
}
