package main

import (
	"github.com/yandex/pandora/core"
	"github.com/yandex/pandora/core/provider"
	"io"
)

type NopDecoder struct {
}

func (n NopDecoder) Decode(ammo core.Ammo) error {
	return nil
}

func NewDecoder(deps core.ProviderDeps, source io.Reader) (provider.AmmoDecoder, error) {
	return &NopDecoder{}, nil
}

func NewAmmoProvider(conf provider.DecodeProviderConfig) core.Provider {
	return provider.NewDecodeProvider(NewAmmo, NewDecoder, conf)
}
