package main

import (
	dataproxy "a.yandex-team.ru/solomon/services/dataproxy/api"
	"context"
	"google.golang.org/grpc"
)

type HostClient interface {
	ReadMany(ctx context.Context, req *dataproxy.ReadManyRequest) (*dataproxy.ReadManyResponse, error)
}

type hostClientImpl struct {
	client dataproxy.DataProxyServiceClient
}

func NewHostClient(ctx context.Context, hostname, port string) (HostClient, error) {
	conn, err := grpc.DialContext(
		ctx,
		hostname+":"+port,
		grpc.WithInsecure(),
		grpc.WithUserAgent("dataproxy_gun"))
	if err != nil {
		return nil, err
	}

	client := dataproxy.NewDataProxyServiceClient(conn)
	return &hostClientImpl{client: client}, nil
}

func (h *hostClientImpl) ReadMany(ctx context.Context, req *dataproxy.ReadManyRequest) (*dataproxy.ReadManyResponse, error) {
	return h.client.ReadMany(ctx, req)
}
