#pragma once

#include <solomon/services/dataproxy/lib/datasource/datasource.h>
#include <solomon/services/dataproxy/lib/cluster_map/cluster_map.h>

#include <library/cpp/actors/core/actorid.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon::NDataProxy {

struct TApiServerContext {
    const TClusterMap& ClusterMap;
    NMonitoring::TMetricRegistry& Registry;
    NActors::TActorId Cache;
    IDataSourcePtr DataSource;

    TApiServerContext(
            const TClusterMap& clusterMap,
            NMonitoring::TMetricRegistry& registry,
            NActors::TActorId cache,
            IDataSourcePtr dataSource)
        : ClusterMap{clusterMap}
        , Registry{registry}
        , Cache{cache}
        , DataSource{std::move(dataSource)}
    {
    }
};


} // namespace NSolomon::NDataProxy
