#pragma once

#include <solomon/services/dataproxy/lib/event_slots.h>
#include <solomon/services/dataproxy/lib/datasource/status_code.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/grpc/server/grpc_request_base.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NDataProxy {

class TApiServerEvents: private TEventSlot<EEventSpace::DataProxy, ES_API_SERVER> {
    enum {
        Request = SpaceBegin,
        Timeout,
        DataLoaded,
        DataLoadError,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TRequest: public NActors::TEventLocal<TRequest, Request> {
        ::NGrpc::IRequestContextBase* RequestCtx;
        TInstant ReceivedAt;

        TRequest(::NGrpc::IRequestContextBase* requestCtx, TInstant receivedAt)
            : RequestCtx{requestCtx}
            , ReceivedAt{receivedAt}
        {
        }
    };

    struct TDataLoaded: public NActors::TEventLocal<TDataLoaded, DataLoaded> {
        TString ReqId;
        std::unique_ptr<::google::protobuf::Message> Data;

        TDataLoaded(TString reqId, std::unique_ptr<::google::protobuf::Message> data)
            : ReqId{std::move(reqId)}
            , Data{std::move(data)}
        {
        }
    };

    struct TDataLoadError: public NActors::TEventLocal<TDataLoadError, DataLoadError> {
        TString ReqId;
        EDataSourceStatus Status;
        TString ErrorMessage;

        TDataLoadError(TString reqId, EDataSourceStatus status, TString errorMessage)
            : ReqId{std::move(reqId)}
            , Status{status}
            , ErrorMessage{std::move(errorMessage)}
        {
        }
    };
};

} // namespace NSolomon::NDataProxy
