#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TFindHandler: public TBaseApiHandler<TFindHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::FindRequest;
    using TResponse = yandex::monitoring::dataproxy::FindResponse;

public:
    explicit TFindHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TFindHandler>(apiCtx, EApiMethod::Find)
    {
    }

    static TFindQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
            TApiServerContext* apiCtx,
            NActors::TActorId parentId,
            TString reqId) const;
};

} // namespace NSolomon::NDataProxy
