#include "grpc_errors.h"

namespace NSolomon::NDataProxy {

grpc::StatusCode ToGrpcStatus(EDataSourceStatus status) noexcept {
    switch (status) {
        case EDataSourceStatus::UNKNOWN:
            return grpc::StatusCode::UNKNOWN;

        case EDataSourceStatus::OK:
            return grpc::StatusCode::OK;

        case EDataSourceStatus::BACKEND_TIMEOUT:
            return grpc::StatusCode::DEADLINE_EXCEEDED;

        case EDataSourceStatus::BAD_REQUEST:
            return grpc::StatusCode::FAILED_PRECONDITION;

        case EDataSourceStatus::NOT_FOUND:
            return grpc::StatusCode::NOT_FOUND;

        case EDataSourceStatus::BACKEND_ERROR:
            return grpc::StatusCode::INTERNAL;

        case EDataSourceStatus::BACKEND_UNAVAILABLE:
            return grpc::StatusCode::UNAVAILABLE;
    }
}

} // namespace NSolomon::NDataProxy
