#include "grpc_meta_service.h"

#include <solomon/services/dataproxy/lib/limits.h>

#include <library/cpp/actors/core/actor.h>

#include <util/string/cast.h>

namespace NSolomon::NDataProxy {

std::optional<TInstant> GetSoftDeadline(const ::NGrpc::IRequestContextBase& req, TInstant hardDeadline) {
    auto range = req.GetPeerMetaValues("x-mon-soft-deadline");
    if (range.size() > 0) {
        ui64 milliSeconds;
        if (!TryFromString<ui64>(range[0], milliSeconds)) {
            return std::nullopt;
        }
        auto softDeadline = TInstant::MilliSeconds(milliSeconds);
        return softDeadline > hardDeadline ? std::nullopt : std::make_optional(softDeadline);
    }
    return std::nullopt;
}

} // namespace NSolomon::NDataProxy
