#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TLabelKeysHandler: public TBaseApiHandler<TLabelKeysHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::LabelKeysRequest;
    using TResponse = yandex::monitoring::dataproxy::LabelKeysResponse;

public:
    explicit TLabelKeysHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TLabelKeysHandler>(apiCtx, EApiMethod::LabelKeys)
    {
    }

    static TLabelKeysQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
