#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TLabelValuesHandler: public TBaseApiHandler<TLabelValuesHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::LabelValuesRequest;
    using TResponse = yandex::monitoring::dataproxy::LabelValuesResponse;

public:
    explicit TLabelValuesHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TLabelValuesHandler>(apiCtx, EApiMethod::LabelValues)
    {
    }

    static TLabelValuesQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
