#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TMetricNamesHandler: public TBaseApiHandler<TMetricNamesHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::MetricNamesRequest;
    using TResponse = yandex::monitoring::dataproxy::MetricNamesResponse;

public:
    explicit TMetricNamesHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TMetricNamesHandler>(apiCtx, EApiMethod::MetricNames)
    {
    }

    static TMetricNamesQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
