#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TReadManyHandler: public TBaseApiHandler<TReadManyHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::ReadManyRequest;
    using TResponse = yandex::monitoring::dataproxy::ReadManyResponse;

public:
    explicit TReadManyHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TReadManyHandler>(apiCtx, EApiMethod::ReadMany)
    {
    }

    static TReadManyQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
