#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TReadOneHandler: public TBaseApiHandler<TReadOneHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::ReadOneRequest;
    using TResponse = yandex::monitoring::dataproxy::ReadOneResponse;

public:
    explicit TReadOneHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TReadOneHandler>(apiCtx, EApiMethod::ReadOne)
    {
    }

    static TReadOneQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
