#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TResolveManyHandler: public TBaseApiHandler<TResolveManyHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::ResolveManyRequest;
    using TResponse = yandex::monitoring::dataproxy::ResolveManyResponse;

public:
    explicit TResolveManyHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TResolveManyHandler>(apiCtx, EApiMethod::ResolveMany)
    {
    }

    static TResolveManyQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
