#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TResolveOneHandler: public TBaseApiHandler<TResolveOneHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::ResolveOneRequest;
    using TResponse = yandex::monitoring::dataproxy::ResolveOneResponse;

public:
    explicit TResolveOneHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TResolveOneHandler>(apiCtx, EApiMethod::ResolveOne)
    {
    }

    static TResolveOneQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
