#pragma once

#include "base_handler.h"

#include <solomon/services/dataproxy/api/dataproxy_service.grpc.pb.h>

namespace NSolomon::NDataProxy {

class TUniqueLabelsHandler: public TBaseApiHandler<TUniqueLabelsHandler> {
public:
    using TRequest = yandex::monitoring::dataproxy::UniqueLabelsRequest;
    using TResponse = yandex::monitoring::dataproxy::UniqueLabelsResponse;

public:
    explicit TUniqueLabelsHandler(TApiServerContext* apiCtx)
        : TBaseApiHandler<TUniqueLabelsHandler>(apiCtx, EApiMethod::UniqueLabels)
    {
    }

    static TUniqueLabelsQuery MakeQuery(::NGrpc::IRequestContextBase* reqCtx);

    std::unique_ptr<NActors::IActor> CreateDataLoader(
        TApiServerContext* apiCtx,
        NActors::TActorId parentId,
        TString reqId) const;
};

} // namespace NSolomon::NDataProxy
