#include "cluster_id.h"

#include <util/string/cast.h>

// arcadia in/out templates specializations

template <>
NSolomon::NDataProxy::TClusterId FromStringImpl<NSolomon::NDataProxy::TClusterId>(const char* data, size_t len) {
    using namespace NSolomon::NDataProxy;

    TClusterId id;
    Y_ENSURE(TryFromString(data, len, id));
    return id;
}

template <>
bool TryFromStringImpl<NSolomon::NDataProxy::TClusterId>(const char* data, size_t len, NSolomon::NDataProxy::TClusterId& id) {
    using namespace NSolomon::NDataProxy;

    TStringBuf dcStr, replicaStr;
    if (!TStringBuf{data, len}.TrySplit('-', dcStr, replicaStr)) {
        return false;
    }

    EDc dc = DcFromStr(dcStr);
    if (dc == EDc::Unknown) {
        return false;
    }

    EReplica replica = ReplicaFromStr(replicaStr);
    if (replica == EReplica::Unknown) {
        return false;
    }

    id = TClusterId{dc, replica};
    return true;
}

template <>
void Out<NSolomon::NDataProxy::TClusterId> (IOutputStream& os, NSolomon::NDataProxy::TClusterId id) {
    os << id.Dc() << '-' << id.Replica();
}
