#pragma once

#include "dc.h"
#include "replica.h"

#include <iostream>
#include <utility>

namespace NSolomon::NDataProxy {

class TClusterId {
public:
    constexpr TClusterId() noexcept = default;

    constexpr TClusterId(EDc dc, EReplica replica) noexcept
        : Id_{static_cast<ui8>((static_cast<ui8>(dc) << 4) | static_cast<ui8>(replica))}
    {
    }

    constexpr bool operator==(const TClusterId& rhs) const noexcept = default;
    constexpr bool operator!=(const TClusterId& rhs) const noexcept = default;

    constexpr operator size_t() const noexcept {
        return Id_;
    }

    [[nodiscard]] constexpr EDc Dc() const noexcept {
        return static_cast<EDc>(Id_ >> 4);
    }

    [[nodiscard]] constexpr EReplica Replica() const noexcept {
        return static_cast<EReplica>(Id_ & 0x0f);
    }

private:
    ui8 Id_{0};
};

inline std::ostream& operator<<(std::ostream& os, TClusterId id) {
    return os << id.Dc() << '-' << id.Replica();
}

inline IOutputStream& operator<<(IOutputStream& os, TClusterId id) {
    return os << id.Dc() << '-' << id.Replica();
}

} // namespace NSolomon::NDataProxy

Y_DECLARE_PODTYPE(NSolomon::NDataProxy::TClusterId);

template <>
struct std::hash<NSolomon::NDataProxy::TClusterId> {
    size_t operator()(NSolomon::NDataProxy::TClusterId id) const noexcept {
        return static_cast<size_t>(id);
    }
};
