#include "dc.h"

#include <util/string/cast.h>

namespace NSolomon::NDataProxy {

TStringBuf DcToStr(EDc dc) {
    switch (dc) {
        case EDc::Unknown: return "unknown";
        case EDc::Sas: return "sas";
        case EDc::Vla: return "vla";
        case EDc::Man: return "man";
        case EDc::Myt: return "myt";
        case EDc::Iva: return "iva";
    }
    // not reachable
}

EDc DcFromStr(TStringBuf str) {
    if (str == "sas") {
        return EDc::Sas;
    } else if (str == "vla") {
        return EDc::Vla;
    } else if (str == "man") {
        return EDc::Man;
    } else if (str == "myt") {
        return EDc::Myt;
    } else if (str == "iva") {
        return EDc::Iva;
    }
    return EDc::Unknown;
}

} // namespace NSolomon::NDataProxy

// arcadia in/out templates specializations

template <>
NSolomon::NDataProxy::EDc FromStringImpl<NSolomon::NDataProxy::EDc>(const char* data, size_t len) {
    return NSolomon::NDataProxy::DcFromStr(TStringBuf{data, len});
}

template <>
void Out<NSolomon::NDataProxy::EDc> (IOutputStream& os, NSolomon::NDataProxy::EDc dc) {
    os << NSolomon::NDataProxy::DcToStr(dc);
}
