#pragma once

#include <util/generic/strbuf.h>
#include <util/stream/output.h>

#include <array>

namespace NSolomon::NDataProxy {

enum class EDc: ui8 {
    Unknown,
    Sas,
    Vla,
    Man,
    Myt,
    Iva,
    // no more than 15 values
};

inline constexpr std::array KnownDcs = {
    EDc::Sas,
    EDc::Vla,
    EDc::Man,
    EDc::Myt,
    EDc::Iva,
};

TStringBuf DcToStr(EDc dc);
EDc DcFromStr(TStringBuf str);

inline std::ostream& operator<<(std::ostream& os, EDc dc) {
    return os << DcToStr(dc);
}

inline IOutputStream& operator<<(IOutputStream& os, EDc dc) {
    return os << DcToStr(dc);
}

} // namespace NSolomon::NDataProxy
