#include "replica.h"

#include <util/string/cast.h>

namespace NSolomon::NDataProxy {

TStringBuf ReplicaToStr(EReplica replica) {
    switch (replica) {
        case EReplica::Unknown: return "unknown";
        case EReplica::R0: return "r0";
        case EReplica::R1: return "r1";
    }
    // not reachable
}

EReplica ReplicaFromStr(TStringBuf str) {
    if (str == "r0") {
        return EReplica::R0;
    } else if (str == "r1") {
        return EReplica::R1;
    }
    return EReplica::Unknown;
}

} // namespace NSolomon::NDataProxy

// arcadia in/out templates specializations

template <>
NSolomon::NDataProxy::EReplica FromStringImpl<NSolomon::NDataProxy::EReplica>(const char* data, size_t len) {
    return NSolomon::NDataProxy::ReplicaFromStr(TStringBuf{data, len});
}

template <>
void Out<NSolomon::NDataProxy::EReplica> (IOutputStream& os, NSolomon::NDataProxy::EReplica replica) {
    os << NSolomon::NDataProxy::ReplicaToStr(replica);
}
