#pragma once

#include <util/generic/strbuf.h>
#include <util/stream/output.h>

#include <array>

namespace NSolomon::NDataProxy {

enum class EReplica: ui8 {
    Unknown,
    R0,
    R1,
};

inline constexpr std::array KnownReplicas = {
    EReplica::R0,
    EReplica::R1,
};

static_assert(std::is_sorted(KnownReplicas.begin(), KnownReplicas.end()));

inline bool IsKnownReplica(EReplica r) {
    return r >= KnownReplicas.front() && r <= KnownReplicas.back();
}

TStringBuf ReplicaToStr(EReplica replica);
EReplica ReplicaFromStr(TStringBuf str);

inline std::ostream& operator<<(std::ostream& os, EReplica replica) {
    return os << ReplicaToStr(replica);
}

inline IOutputStream& operator<<(IOutputStream& os, EReplica replica) {
    return os << ReplicaToStr(replica);
}

} // namespace NSolomon::NDataProxy
